<?php

/**
 * Dragonbyte-Tech.com Downloads Mod 1.0.0
 * 
 * @author David Tobin
 * @copyright 2010
 * @version 1.0
 * 
 * You may not copy/reproduce any part of this file in whole or significant part.
 * 
 * All rights reserved.
 */

class uploadModule {
	protected $registry;
	
	private $files 			= array();
	private $filecount 		= 0;
	
	protected $groupid		= 0;
	protected $groupname	= '';
	protected $groupdesc    = '';

	private $category		= 0;
	
	private $allowedexts 	= array();
	private $allowedsizes 	= array();
	
	private $private		= false;
	private $password		= false;
	private $moderation		= 0;
	
	protected $toforum        = 0;
	
	private $updating		= false;
	
	public $flashupload		= false;
	
	public function __construct($registry) {
		$this->registry = $registry;
		
		($hook = vBulletinHook::fetch_hook('dbtech_downloads_module_upload_construct')) ? eval($hook) : false;
	}
	
	public function set_group_id($groupid) {
		$this->groupid = $groupid;
	}
	
	private function count_files($add=0) {
		$precount = count($_FILES['upload']['name']);

		if ($precount > 1) {
			for ($i=0; $i<$precount;$i++) {
				if ($_FILES['upload']['tmp_name'][$i] == '') {
					unset($_FILES['upload']['tmp_name'][$i], $_FILES['upload']['error'][$i], $_FILES['upload']['name'][$i], $_FILES['upload']['type'][$i], $_FILES['upload']['size'][$i]);
				}
			}
		}
		
		if ($this->flashupload == true) {
			$tempfiles = $_FILES;
			
			unset($_FILES['upload']);
			
			$_FILES['upload'] = array();
			
			$_FILES['upload']['tmp_name'][0] = $tempfiles['upload']['tmp_name'];
			$_FILES['upload']['name'][0] = $tempfiles['upload']['name'];
			$_FILES['upload']['type'][0] = $tempfiles['upload']['type'];
			$_FILES['upload']['error'][0] = $tempfiles['upload']['error'];
			$_FILES['upload']['size'][0] = $tempfiles['upload']['size'];			
		}
		
		$this->registry->input->clean_gpc('f', 'upload', TYPE_ARRAY_FILE);
		
		$files 					= $this->registry->GPC['upload'];
		
		$filecount 			= count($files['tmp_name']);

		$this->filecount 	= $filecount + $add;
		$this->files 			= $files;
		
	}
	
	private function check_files() {

		global $vbphrase;

		$catinfo = $this->registry->db->query_first("
			SELECT * FROM " . TABLE_PREFIX . "dbtech_downloads_categories
			WHERE catid = " . intval($this->category) . "
		");
		
		$permissions 		= unserialize($catinfo['permissions']);
		$secondary			= explode(',', $this->registry->userinfo['membergroupids']);
		
		$this->allowedexts 	= array();
		
		$canup = false;
		foreach ($secondary AS $ugid) {
			if (in_array($ugid, (array)$permissions['upload'])) {
				$canup = true;
			}
		}
		
		if (!empty($permissions)) {
			if (!in_array($this->registry->userinfo['usergroupid'], (array)$permissions['upload']) && $canup == false) {
				if ($this->flashupload == false) {
					print_no_permission();
				}
			}
		}

		if ($catinfo['password'] == 1) {
			$this->password = true;
		}

		if ($catinfo['private'] == 1) {
			$this->private	= true;
		}

		if ($catinfo['moderation'] == 1) {
			$this->moderation = 1;
		}

		if ($catinfo['toforum'] > 0) {
			$this->toforum = $catinfo['toforum'];
		}

		$extgroupids = explode(',', $catinfo['extgroupids']);

		if ($catinfo['extgroupids']) {
			$extensions = $this->registry->db->query_read("
				SELECT * FROM " . TABLE_PREFIX . "dbtech_downloads_extensions
				WHERE extgroupid IN (" . $catinfo['extgroupids'] . ")
			");

			while ($extension = $this->registry->db->fetch_array($extensions))
			{
				array_push($this->allowedexts, $extension['extension']);

				$this->allowedsizes[$extension['extension']] = $extension['maxsize'];
			}

			foreach ((array)$this->files['name'] AS $fid => $filename)
			{
				$splitfile = explode('.', strtolower($filename));

				if (!in_array(strtolower(end($splitfile)), $this->allowedexts))
				{
					if (!empty($filename)) {
						if ($this->flashupload == false) {
							standard_error(fetch_error('dbtech_downloads_invalid_extension'));
						} else {
                            die(fetch_error('dbtech_downloads_invalid_extension'));
						}
					}
				}

				if (filesize($this->files['tmp_name'][$fid]) > $this->allowedsizes[end($splitfile)]) {
					$sizeerror = construct_phrase($vbphrase['dbtech_downloads_file_too_big'], end($splitfile), $this->allowedsizes[end($splitfile)]);

					if ($this->flashupload == false) {
						standard_error($sizeerror);
					} else {
						die($sizeerror);
					}
				}

				$max_upload = ((int)(ini_get('upload_max_filesize')) * 1024 * 1024);

				if (filesize($this->files['tmp_name'][$fid]) > $max_upload) {

					$sizeerror = construct_phrase($vbphrase['dbtech_downloads_file_too_big'], end($splitfile), $max_upload);

					if ($this->flashupload == false) {
						standard_error($sizeerror);
					} else {
						die($sizeerror);
					}
				}
			}
		}
	}
	
	public function fetch_uploaded_files($category) {
		global $vbphrase;

		$this->count_files();

		$this->category	= $category;

		$this->check_files();

		($hook = vBulletinHook::fetch_hook('dbtech_downloads_module_upload_fetch_files')) ? eval($hook) : false;
	}
	
	public function update_filegroup($groupid, $groupname, $groupdesc='') {
		$this->updating = true;
		
		if (!$this->registry->userinfo['userid']) {
			if ($this->flashupload == false) {
				print_no_permission();
			} else {
				die("0");
			}
		}

		/*DBTECH_PRO_START*/
		$passwordSQL 	= ", password = ''";
		/*DBTECH_PRO_END*/  		
		$privatelist	= '';
		
		if ($this->category == 0) {
			$this->category = $this->registry->input->clean_gpc('p', 'catid', TYPE_INT);
		}
		
		if (!empty($groupname)) {
			
			$mirrors = $this->registry->input->clean_gpc('p', 'mirrors', TYPE_ARRAY_STR);
			
			if (empty($mirrors) || $this->registry->options['dbtech_downloads_mirrors_enabled'] == false) {
				$mirrors = '';
			} else {
				$i = 1;
				foreach ($mirrors AS $i => $mirror) {
					if ($i < $this->registry->options['dbtech_downloads_max_downloads']) {
						if ($mirror == '' || $mirror == 'http://' || $mirror == '//:http') {
							unset($mirrors[$i]);
						}
					}
					
					$i++;
				}
				
				$mirrors = serialize($mirrors);
			}
			
			($hook = vBulletinHook::fetch_hook('dbtech_downloads_module_upload_update_filegroup_prewrite')) ? eval($hook) : false;
			
			if ($this->flashupload == true) {
				$groupname 		= convert_urlencoded_unicode($groupname);
				$groupdesc 		= convert_urlencoded_unicode($groupdesc);
				$privatelist 			= convert_urlencoded_unicode($privatelist);
				$mirrors				= convert_urlencoded_unicode($mirrors);
				$passwordSQL		= convert_urlencoded_unicode($passwordSQL);
			}
			
		
			$this->registry->db->query_write("
				UPDATE " . TABLE_PREFIX ."dbtech_downloads_filegroup
				SET
					groupname 	= '" . $this->registry->db->escape_string($groupname) . "',
					groupdesc	= '" . $this->registry->db->escape_string($groupdesc) . "',
					updated		= '" . TIMENOW . "',
					categoryid	= '" . $this->category . "',
					private		= " . $this->registry->db->sql_prepare($privatelist) . ",
					mirrors		= '" . $this->registry->db->escape_string($mirrors) . "'
					$passwordSQL
					
				WHERE groupid = $groupid
			");

			$this->groupname 	= $groupname;
			$this->groupid		= $groupid;
		}
	}
	
	public function create_filegroup($groupname, $groupdesc='') {
		$this->updating = false;
		
		if (!$this->registry->userinfo['userid']) {
			if ($this->flashupload == false) {
				print_no_permission();
			} else {
				die("0");
			}
		}

		/*DBTECH_PRO_START*/
		$passwordSQL 	= ", password = ''";
		/*DBTECH_PRO_END*/  
		$privatelist	= '';
		
		if ($this->category == 0) {
			$this->category = $this->registry->input->clean_gpc('p', 'catid', TYPE_INT);
		}
		
		if (!empty($groupname)) {
			
			$mirrors = $this->registry->input->clean_gpc('p', 'mirrors', TYPE_ARRAY_STR);
			
			if (empty($mirrors) || $this->registry->options['dbtech_downloads_mirrors_enabled'] == false) {
				$mirrors = '';
			} else {
				$i = 1;
				foreach ($mirrors AS $i => $mirror) {
					if ($i < $this->registry->options['dbtech_downloads_max_downloads']) {
						if ($mirror == '' || $mirror == 'http://') {
							unset($mirrors[$i]);
						}
					}
					
					$i++;
				}
				
				$mirrors = serialize($mirrors);
			}
			
			($hook = vBulletinHook::fetch_hook('dbtech_downloads_module_upload_add_filegroup_prewrite')) ? eval($hook) : false;
			
			if ($this->flashupload == true) {
				$groupname 		= convert_urlencoded_unicode($groupname);
				$groupdesc 		= convert_urlencoded_unicode($groupdesc);
				$privatelist 	= convert_urlencoded_unicode($privatelist);
				$mirrors		= convert_urlencoded_unicode($mirrors);
				$passwordSQL	= convert_urlencoded_unicode($passwordSQL);
			}
			
			$this->registry->db->query_write("
				INSERT INTO " . TABLE_PREFIX . "dbtech_downloads_filegroup (userid, groupname, groupdesc, updated, categoryid, moderation, private, mirrors)
				VALUES 	(
							" . intval($this->registry->userinfo['userid']) . ",
							'" . $this->registry->db->escape_string($groupname) . "',
							'" . $this->registry->db->escape_string($groupdesc) . "',
							'" . TIMENOW . "',
							'" . intval($this->category) . "',
							'" . $this->moderation . "',
							'" . $this->registry->db->escape_string($privatelist) . "',
							'" . $this->registry->db->escape_string($mirrors) . "'
						)
			");
			
			$this->groupname 	= $groupname;
			$this->groupdesc    = $groupdesc;
			$this->groupid 		= $this->registry->db->insert_id();

			$this->registry->db->query_write("
				UPDATE " . TABLE_PREFIX ."dbtech_downloads_filegroup
				SET
					groupname 	= '" . $this->registry->db->escape_string($groupname) . "'
					$passwordSQL
				WHERE groupid = " . intval($this->groupid)
			);

			if ($this->toforum > 0 && method_exists($this, 'post_new_thread')) {
				$this->post_new_thread();
			} else {
				if ($this->flashupload == true) {
					$catinfo = $this->registry->db->query_first("
						SELECT * FROM " . TABLE_PREFIX . "dbtech_downloads_categories
						WHERE catid = " . intval($this->category) . "
					");

					if ($catinfo['toforum'] > 0) {
						$this->toforum = $catinfo['toforum'];

						$this->post_new_thread();
					}
				}
			}

			return $this->groupid;
		}
	}
	
	public function add_files() {
		global $vbphrase;
		
		$imageid = 0;
		$fileids = array();
		
		$checkfilecount = $this->registry->db->query_first("
			SELECT COUNT(fileid) as total FROM " . TABLE_PREFIX . "dbtech_downloads_fileinfo
			WHERE parentid = " . $this->groupid . " AND screenshot = '0'
		");
		
		
		if ($checkfilecount['total'] + $this->filecount > $this->registry->options['dbtech_downloads_max_downloads']) {
			if ($this->flashupload == false) {
				standard_error(fetch_error('dbtech_downloads_too_many_files'));
			} else {
				die(fetch_error('dbtech_downloads_too_many_files'));
			}
		}
		
		if ($this->groupid > 0) {
			
			if ($this->filecount <= $this->registry->options['dbtech_downloads_max_downloads']) {
				for($i=0; $i <= $this->filecount; $i++) {
					
					if ($this->files['tmp_name'][$i]) {
						
						$typesplit = explode('.', $this->files['name'][$i]);
						
						if (in_array(strtolower(end($typesplit)), array('gif', 'jpg', 'jpeg', 'png'))) {
							$isimage = 1;
						} else {
							$isimage = 0;
						}
						
						$filehash = md5_file($this->files['tmp_name'][$i]);
						
						/*
						$checkfilehash = $this->registry->db->query_first("
							SELECT * FROM " . TABLE_PREFIX . "dbtech_downloads_filehash
							WHERE md5 = '" . $filehash . "'
						");
						*/
						if (empty($checkfilehash)) {
							$this->registry->db->query_write("
								INSERT INTO " . TABLE_PREFIX . "dbtech_downloads_fileinfo (userid, filename, image, dateline, filesize, filetype, private, parentid)
								VALUES	(
											" . $this->registry->userinfo['userid'] . ",
											'" . $this->registry->db->escape_string($this->files['name'][$i]) . "',
											" . $isimage . ",
											'" . TIMENOW . "',
											'" . $this->registry->db->escape_string(filesize($this->files['tmp_name'][$i])) . "',
											'" . $this->registry->db->escape_string($this->files['type'][$i]) . "',
											0,
											" . intval($this->groupid) . "
										)
							");
							
							$fileid = strval($this->registry->db->insert_id());
							
							$this->registry->db->query_write("
								INSERT INTO " . TABLE_PREFIX . "dbtech_downloads_filehash (fileid, md5)
								VALUES	(
											" . $fileid . ",
											'" . $filehash . "'
										)
							");
							
							$fileids[] = $fileid;
							
							($hook = vBulletinHook::fetch_hook('dbtech_downloads_module_upload_add_files_premove')) ? eval($hook) : false;
							
							move_uploaded_file($this->files['tmp_name'][$i], $this->registry->options['dbtech_downloads_path_to_downloads'] . '/' . $fileid . '-' . $this->files['name'][$i]);
						} else {
							global $vbphrase;
							
							$dupe = $this->registry->db->query_first("
								SELECT parentid FROM " . TABLE_PREFIX . "dbtech_downloads_fileinfo
								WHERE fileid = " . $checkfilehash['fileid'] . "
							");
							
							$phrasetext = construct_phrase($vbphrase['dbtech_downloads_file_exists'], $dupe['parentid']);
							
							standard_error($phrasetext);
						}
					}	
				}
			} else {
			for($i=0; $i <= $this->registry->options['dbtech_downloads_max_downloads']; $i++) {
					if ($this->files['tmp_name'][$i]) {
						$this->registry->db->query_write("
							INSERT INTO " . TABLE_PREFIX . "dbtech_downloads_fileinfo (userid, filename, dateline, filesize, filetype, private, parentid)
							VALUES	(
										" . $this->registry->userinfo['userid'] . ",
										'" . $this->registry->db->escape_string($this->files['name'][$i]) . "',
										'" . TIMENOW . "',
										'" . $this->registry->db->escape_string(filesize($this->files['tmp_name'][$i])) . "',
										'" . $this->registry->db->escape_string($this->files['type'][$i]) . "',
										0,
										" . intval($this->groupid) . "
									)
						");
						$fileid = strval($this->registry->db->insert_id());
						
						$typesplit = explode('.', $this->files['name'][$i]);
						
						if (in_array(strtolower(end($typesplit)), array('gif', 'jpg', 'jpeg', 'png'))) {
							$isimage = 1;
						} else {
							$isimage = 0;
						}
						
						$fileids[] = $fileid;
						
						($hook = vBulletinHook::fetch_hook('dbtech_downloads_module_upload_add_files_premove')) ? eval($hook) : false;
						
						move_uploaded_file($this->files['tmp_name'][$i], $this->registry->options['dbtech_downloads_path_to_downloads'] . '/' . $fileid . '-' . $this->files['name'][$i]);
					}
				}				
			}
		}
		
		$filecount = $this->registry->db->query_first("
			SELECT COUNT(fileid) AS files FROM " . TABLE_PREFIX . "dbtech_downloads_fileinfo
			WHERE parentid = " . intval($this->groupid) . "
		");
		
		$this->registry->db->query_write("
				UPDATE " . TABLE_PREFIX . "dbtech_downloads_filegroup
					SET
						image 		= IF(image = 0, '" . $imageid . "', image),
						files 		= '" . implode(',', (array)$fileids) . "',
						filecount 	= " . intval($filecount['files']) . "
				WHERE groupid = " . intval($this->groupid) . "
			");
		
		if ($this->updating == false && $this->private == false && $this->flashupload == false) {
			global $vbshout;
			
			foreach ((array)$vbshout->cache['instance'] as $instanceid => $instance)
			{
				// Init the Shout DM
				$shout = $vbshout->datamanager_init('vBShout', $this->registry, ERRTYPE_ARRAY);
				$shout->set('message', construct_phrase($vbphrase['dbtech_downloads_vbshout_message'], $this->registry->options['bburl'], $this->registry->options['dbtech_downloads_link'], $this->groupid, $this->registry->db->escape_string($this->groupname)))
					->set('type', $vbshout->shouttypes['notif'])
					->set('instanceid', $instanceid);
				
				// Get the shout id
				$shoutid = $shout->save();
				unset($shout);
			}
		}
			
		if ($this->flashupload == false) {
			return $this->groupid;
		} else {
			echo "1";
			exit;
		}
	}
	
	public function add_thumbnail($group) {
		$screenshot = $this->registry->input->clean_gpc('f', 'screenshot', TYPE_FILE);
		
		$groupid = intval($group['groupid']);
		
		if (!empty($screenshot['name'])) {
			if ($group && ($this->registry->userinfo['userid'] == $group['userid'] || Downloads::is_mod() == true)) {
				require_once(DIR . '/dbtech/downloads/core/class_resizer.php');
				$resizer = new Resizer($this->registry);
				
				if (count($screenshot > 0)) {
					$filesize = getimagesize($screenshot['tmp_name']);
		
					$filetype = explode('/', $screenshot['type']);
					$filetype = $filetype[1];
					
					$resizer->setImageType($filetype);
					$resizer->setCurrentSize($filesize[1], $filesize[0]);
					$doresize = $resizer->getImage($screenshot['tmp_name']);
					
					if ($doresize == true) {
						$resizer->resize($this->registry->options['dbtech_downloads_path_to_downloads'] . '/' . strtolower($groupid . '-thumb-' . $screenshot['name']));
					}
					
					$this->registry->db->query_write("
						UPDATE " . TABLE_PREFIX . "dbtech_downloads_filegroup
						SET
								image = '" . $this->registry->db->escape_string(strtolower($screenshot['name'])) . "'
						WHERE groupid = " . $groupid . "		
					");
					
					return true;
				}
			} else {
				return false;
			}
		} else {
			return false;
		}
	}
}